if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface Mypage_Params {
    globalDarkMode?: boolean;
    notificationEnabled?: boolean;
    vibrationEnabled?: boolean;
    isInitialized?: boolean;
    listenerId?: string;
}
import router from "@ohos:router";
import ThemeManager from "@bundle:com.example.myapplication/entry/ets/common/ThemeManager";
class Mypage extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__globalDarkMode = new ObservedPropertySimplePU(false, this, "globalDarkMode");
        this.__notificationEnabled = new ObservedPropertySimplePU(true, this, "notificationEnabled");
        this.__vibrationEnabled = new ObservedPropertySimplePU(true, this, "vibrationEnabled");
        this.__isInitialized = new ObservedPropertySimplePU(false, this, "isInitialized");
        this.listenerId = '';
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: Mypage_Params) {
        if (params.globalDarkMode !== undefined) {
            this.globalDarkMode = params.globalDarkMode;
        }
        if (params.notificationEnabled !== undefined) {
            this.notificationEnabled = params.notificationEnabled;
        }
        if (params.vibrationEnabled !== undefined) {
            this.vibrationEnabled = params.vibrationEnabled;
        }
        if (params.isInitialized !== undefined) {
            this.isInitialized = params.isInitialized;
        }
        if (params.listenerId !== undefined) {
            this.listenerId = params.listenerId;
        }
    }
    updateStateVars(params: Mypage_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__globalDarkMode.purgeDependencyOnElmtId(rmElmtId);
        this.__notificationEnabled.purgeDependencyOnElmtId(rmElmtId);
        this.__vibrationEnabled.purgeDependencyOnElmtId(rmElmtId);
        this.__isInitialized.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__globalDarkMode.aboutToBeDeleted();
        this.__notificationEnabled.aboutToBeDeleted();
        this.__vibrationEnabled.aboutToBeDeleted();
        this.__isInitialized.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __globalDarkMode: ObservedPropertySimplePU<boolean>;
    get globalDarkMode() {
        return this.__globalDarkMode.get();
    }
    set globalDarkMode(newValue: boolean) {
        this.__globalDarkMode.set(newValue);
    }
    private __notificationEnabled: ObservedPropertySimplePU<boolean>;
    get notificationEnabled() {
        return this.__notificationEnabled.get();
    }
    set notificationEnabled(newValue: boolean) {
        this.__notificationEnabled.set(newValue);
    }
    private __vibrationEnabled: ObservedPropertySimplePU<boolean>;
    get vibrationEnabled() {
        return this.__vibrationEnabled.get();
    }
    set vibrationEnabled(newValue: boolean) {
        this.__vibrationEnabled.set(newValue);
    }
    private __isInitialized: ObservedPropertySimplePU<boolean>;
    get isInitialized() {
        return this.__isInitialized.get();
    }
    set isInitialized(newValue: boolean) {
        this.__isInitialized.set(newValue);
    }
    private listenerId: string;
    async aboutToAppear(): Promise<void> {
        if (!this.isInitialized) {
            // 关键修复：使用同步方法立即设置UI状态
            this.globalDarkMode = ThemeManager.getCurrentThemeSync();
            // 异步验证状态一致性
            const actualTheme = await ThemeManager.getIsDarkMode();
            if (this.globalDarkMode !== actualTheme) {
                this.globalDarkMode = actualTheme;
            }
            this.isInitialized = true;
            console.info(`Mypage初始化完成: ${this.globalDarkMode ? '深色' : '浅色'}`);
        }
        // 关键修复：简化监听器逻辑
        const themeCallback = (isDark: boolean) => {
            if (this.globalDarkMode !== isDark) {
                console.info(`监听器触发主题变更: ${isDark ? '深色' : '浅色'}`);
                this.globalDarkMode = isDark;
            }
        };
        if (!ThemeManager.hasListener(themeCallback)) {
            this.listenerId = ThemeManager.addListener(themeCallback);
        }
    }
    aboutToDisappear(): void {
        if (this.listenerId) {
            ThemeManager.removeListener(this.listenerId);
            this.listenerId = '';
        }
    }
    async toggleTheme(): Promise<void> {
        const newTheme = !this.globalDarkMode;
        console.info(`切换主题: ${this.globalDarkMode ? '深色' : '浅色'} -> ${newTheme ? '深色' : '浅色'}`);
        // 立即更新UI状态
        this.globalDarkMode = newTheme;
        // 异步更新全局状态
        await ThemeManager.setTheme(newTheme);
    }
    getBackgroundColor(): string {
        return this.globalDarkMode ? '#000000' : '#FFFFFF';
    }
    getTextColor(): string {
        return this.globalDarkMode ? '#FFFFFF' : '#000000';
    }
    getCardColor(): string {
        return this.globalDarkMode ? '#1C1C1E' : '#F8F8F8';
    }
    getSecondaryTextColor(): string {
        return this.globalDarkMode ? '#8E8E93' : '#666666';
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 20 });
            Column.width('100%');
            Column.height('100%');
            Column.padding(20);
            Column.backgroundColor(this.getBackgroundColor());
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('我的页面');
            Text.fontSize(24);
            Text.fontWeight(FontWeight.Bold);
            Text.margin({ bottom: 30 });
            Text.fontColor(this.getTextColor());
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 主题设置卡片
            Column.create({ space: 15 });
            // 主题设置卡片
            Column.width('90%');
            // 主题设置卡片
            Column.padding(20);
            // 主题设置卡片
            Column.backgroundColor(this.getCardColor());
            // 主题设置卡片
            Column.borderRadius(12);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('主题设置');
            Text.fontSize(18);
            Text.fontWeight(FontWeight.Medium);
            Text.width('100%');
            Text.textAlign(TextAlign.Start);
            Text.fontColor(this.getTextColor());
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('100%');
            Row.padding(10);
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('深色模式');
            Text.fontSize(16);
            Text.layoutWeight(1);
            Text.fontColor(this.getTextColor());
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Toggle.create({ type: ToggleType.Switch, isOn: this.globalDarkMode });
            Toggle.onChange((isOn: boolean) => {
                this.toggleTheme();
            });
        }, Toggle);
        Toggle.pop();
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('开启后应用将使用深色主题，减少视觉疲劳');
            Text.fontSize(12);
            Text.fontColor(this.getSecondaryTextColor());
            Text.width('100%');
            Text.textAlign(TextAlign.Start);
        }, Text);
        Text.pop();
        // 主题设置卡片
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 其他设置项
            Column.create({ space: 15 });
            // 其他设置项
            Column.width('90%');
            // 其他设置项
            Column.padding(20);
            // 其他设置项
            Column.backgroundColor(this.getCardColor());
            // 其他设置项
            Column.borderRadius(12);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('应用设置');
            Text.fontSize(18);
            Text.fontWeight(FontWeight.Medium);
            Text.width('100%');
            Text.textAlign(TextAlign.Start);
            Text.fontColor(this.getTextColor());
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('100%');
            Row.padding(10);
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('通知提醒');
            Text.fontSize(16);
            Text.layoutWeight(1);
            Text.fontColor(this.getTextColor());
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Toggle.create({ type: ToggleType.Switch, isOn: this.notificationEnabled });
            Toggle.onChange((isOn: boolean) => {
                this.notificationEnabled = isOn;
            });
        }, Toggle);
        Toggle.pop();
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('100%');
            Row.padding(10);
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('振动反馈');
            Text.fontSize(16);
            Text.layoutWeight(1);
            Text.fontColor(this.getTextColor());
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Toggle.create({ type: ToggleType.Switch, isOn: this.vibrationEnabled });
            Toggle.onChange((isOn: boolean) => {
                this.vibrationEnabled = isOn;
            });
        }, Toggle);
        Toggle.pop();
        Row.pop();
        // 其他设置项
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Blank.create();
            Blank.layoutWeight(1);
        }, Blank);
        Blank.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('返回主页');
            Button.type(ButtonType.Normal);
            Button.width('90%');
            Button.height(45);
            Button.backgroundColor(this.getCardColor());
            Button.fontColor(this.getTextColor());
            Button.onClick(() => {
                router.back();
            });
        }, Button);
        Button.pop();
        Column.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "Mypage";
    }
}
registerNamedRoute(() => new Mypage(undefined, {}), "", { bundleName: "com.example.myapplication", moduleName: "entry", pagePath: "pages/Mypage", pageFullPath: "entry/src/main/ets/pages/Mypage", integratedHsp: "false" });
